import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import Text from 'components/Text/Text';
import WhiteLabelPartnerLoyaltyLogo from 'components/WhiteLabelPartnerLoyaltyLogo/WhiteLabelPartnerLoyaltyLogo';

import cx from './WhiteLabelPartnerLoyaltyInfo.scss';

interface IWhiteLabelPartnerLoyaltyInfoProps extends IWithClassName {}

const WhiteLabelPartnerLoyaltyInfo: React.FC<IWhiteLabelPartnerLoyaltyInfoProps> =
    ({className}) => {
        const {config: whiteLabelConfig} = useWhiteLabelConfig();

        if (!whiteLabelConfig) {
            return null;
        }

        const description = whiteLabelConfig.orderLoyaltyDescription;

        return (
            <div className={cx('root', className)}>
                <WhiteLabelPartnerLoyaltyLogo />
                {description && (
                    <Text size="s" color="secondary" className={cx('text')}>
                        {description}
                    </Text>
                )}
            </div>
        );
    };

export default React.memo(WhiteLabelPartnerLoyaltyInfo);
