import {MIN_ADULT_AGE} from 'projects/hotels/constants/guests';

import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';

import {getBoardingAge} from 'utilities/dateUtils/getBoardingAge';
import {getNow} from 'utilities/dateUtils';
import {ROBOT} from 'utilities/dateUtils/formats';

export function excludeAdultGuests(
    passengers: IPassengerWithDocumentsDTO[],
    startDate?: string,
) {
    return passengers.filter(
        passenger =>
            getBoardingAge(
                passenger.birth_date,
                startDate || new Date(getNow()).toString(),
                ROBOT,
            ) < MIN_ADULT_AGE,
    );
}
