import {IOrderGuestsInfo} from 'server/api/HotelsBookAPI/types/IOrder';
import {IBookSearchParams} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {
    EBookGuestFieldName,
    EFormGroup,
    IBookFormValues,
} from 'types/hotels/book/IBookFormValues';

function getGuestsByOrderInfo(
    guestsInfo: IOrderGuestsInfo,
    searchParams: IBookSearchParams,
): Pick<IBookFormValues, EFormGroup.ADULT | EFormGroup.CHILDREN> {
    const {adults, childrenAges} = searchParams;

    return {
        adult: guestsInfo.guests
            .slice(0, adults)
            .map((adult, i) => ({...adult, [EBookGuestFieldName.INDEX]: i})),
        children: childrenAges.map((age, index) => {
            const children = guestsInfo.guests[adults + index];

            return {
                age,
                firstName: children?.firstName || '',
                lastName: children?.lastName || '',
            };
        }),
    };
}

export default getGuestsByOrderInfo;
