import {IPromoCampaigns} from 'types/hotels/book/IPromoCampaigns';

import {IBookPromoCodesReducer} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/reducer';

const getTotalWithdrawPlusPoints = ({
    promoCampaigns,
    promoCodesInfo,
}: {
    promoCampaigns?: IPromoCampaigns;
    promoCodesInfo?: IBookPromoCodesReducer;
}): number | undefined => {
    // Берем информацию о промокомпаниях по приоритету из:
    // 1. из ручки estimate_discount
    // 2. из ручки offer_info_by_token
    const resultPromoCampaigns =
        promoCodesInfo?.isSuccess && promoCodesInfo?.data
            ? promoCodesInfo?.data.promoCampaigns
            : promoCampaigns;

    return resultPromoCampaigns?.yandexPlus?.eligible
        ? resultPromoCampaigns.yandexPlus.withdrawPoints
        : 0;
};

export default getTotalWithdrawPlusPoints;
