import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

import {IGeoRegionSlugRouteMatch} from 'types/hotels/geoRegion/IGeoRegionSlugRouteMatch';

import {StoreInterface} from 'reducers/storeTypes';
import {
    fetchGeoRegionInfoActions,
    TFetchGeoRegionInfo,
} from 'reducers/hotels/geoRegionPage/actions';
import {
    resetFilterAction,
    ResetFilterActionType,
} from 'reducers/hotels/searchPage/filters/actions';

import geoRegionPageSelector from 'selectors/hotels/geoRegion/geoRegionPageSelector';

import deviceTypeProvider, {
    IDeviceTypeProvider,
} from 'components/DeviceTypeProvider/DeviceTypeProvider';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import {fetchGeoRegionInfoSSR} from 'server/redux/hotels/fetchGeoRegionInfo';

const mapStateToProps = (state: StoreInterface) => geoRegionPageSelector(state);
const mapDispatchToProps = {
    fetchGeoRegionInfo: fetchGeoRegionInfoActions.request,
    resetFilter: resetFilterAction,
};

import GeoRegionPage from './GeoRegionPage';

type TGeoRegionPageStatePropsContainer = ReturnType<
    typeof geoRegionPageSelector
>;

interface IGeoRegionPageDispatchPropsContainer {
    fetchGeoRegionInfo: TFetchGeoRegionInfo;
    resetFilter: ResetFilterActionType;
}

export type TGeoRegionPagePropsContainer = TGeoRegionPageStatePropsContainer &
    IGeoRegionPageDispatchPropsContainer &
    RouteComponentProps<IGeoRegionSlugRouteMatch> &
    IDeviceTypeProvider;

export default _flow(
    withRouter,
    connect<
        TGeoRegionPageStatePropsContainer,
        IGeoRegionPageDispatchPropsContainer,
        RouteComponentProps<{}>,
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    serverFetchDataDispatcher([fetchGeoRegionInfoSSR]),
    deviceTypeProvider,
)(GeoRegionPage);
