import {FC, ReactNode, useMemo} from 'react';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {TBreadcrumb} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';

import {internalUrl} from 'utilities/url';
import {getBreadcrumbInfo} from 'projects/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18block from 'i18n/hotels-GeoRegionPage';

import Breadcrumbs from 'components/Breadcrumbs/Breadcrumbs';
import Link from 'components/Link/Link';

import {IBreadCrumbsProps} from '../GeoRegionPageBreadCrumbs';

import cx from './GeoRegionPageBreadCrumbsDesktop.scss';

const GeoRegionPageBreadCrumbsDesktop: FC<IBreadCrumbsProps> = props => {
    const {className, breadcrumbs} = props;
    const breadcrumbHotels = useMemo(() => {
        return (
            <Breadcrumbs.Item className={cx('breadCrumb')} hasMicrodata>
                <Link
                    theme="ghost"
                    to={internalUrl(URLs[EProjectName.HOTELS])}
                    itemProp="item"
                >
                    <span itemProp="name">{i18block.breadCrumbHotel()}</span>
                    <meta itemProp="position" content={String(1)} />
                </Link>
            </Breadcrumbs.Item>
        );
    }, []);

    function renderBreadcrumb(
        breadcrumb: TBreadcrumb,
        index: number,
    ): ReactNode {
        const active = index === breadcrumbs.items.length - 1;
        const {text, link} = getBreadcrumbInfo(breadcrumb, breadcrumbs);

        const textNode = <span itemProp="name">{text}</span>;

        return (
            <Breadcrumbs.Item
                key={index}
                className={cx('breadCrumb', active && 'breadCrumb_active')}
                active={active}
                hasMicrodata
            >
                {!active && link ? (
                    <Link to={link} theme="ghost" itemProp="item">
                        {textNode}
                    </Link>
                ) : (
                    textNode
                )}
                <meta itemProp="position" content={String(index + 2)} />
            </Breadcrumbs.Item>
        );
    }

    return (
        <div className={cx(className)} {...prepareQaAttributes(props)}>
            <Breadcrumbs x={0} hasBorder hasMicrodata>
                {breadcrumbHotels}
                {breadcrumbs.items.map(renderBreadcrumb)}
            </Breadcrumbs>
        </div>
    );
};

export default GeoRegionPageBreadCrumbsDesktop;
