import {matchPath} from 'react-router-dom';

import {URLs} from 'constants/urls';

import {IGeoRegionSlugRouteMatch} from 'types/hotels/geoRegion/IGeoRegionSlugRouteMatch';

interface IHotelRegionSlugs {
    regionSlug?: string;
    filterSlug?: string;
}

export const getHotelRegionSlugs = (path: string): IHotelRegionSlugs => {
    const matchData = matchPath<IGeoRegionSlugRouteMatch>(path, {
        path: [URLs.hotelsGeoRegionPageWithFilters, URLs.hotelsGeoRegionPage],
    });
    const regionSlug = matchData?.params?.regionSlug;
    const filterSlug = matchData?.params?.filterSlug;

    return {
        regionSlug,
        filterSlug,
    };
};
