import React, {useEffect} from 'react';
import {useLocation} from 'react-router-dom';
import {useSelector} from 'react-redux';

import {EProjectName} from 'constants/common';

import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {EFooterProject} from 'components/Footer/types';
import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';

import hotelHappyPageSelector from 'selectors/happyPage/hotelHappyPageSelector';

import getQuery from 'projects/happyPage/utilities/url/getQuery';
import {reachGoal} from 'utilities/metrika';

import HappyPageLayout from 'components/Layouts/HappyPageLayout/HappyPageLayout';
import ErrorPage from 'projects/happyPage/components/ErrorPage/ErrorPage';
import HappyPageContent from 'projects/hotels/pages/HappyPage/components/HappyPageContent/HappyPageContent';

import useRequestHappyPageInfo from 'projects/happyPage/hooks/useRequestHappyPageInfo';

const HappyPage: React.FC = () => {
    const location = useLocation();

    const {orderId} = getQuery(location);

    const {
        happyPageInfo: {value: orderAndCrossSalesInfo, errorResponse, isFailed},
    } = useSelector(hotelHappyPageSelector);

    useRequestHappyPageInfo(orderId, EOrderApiType.HOTEL);

    useEffect(() => {
        reachGoal(EHotelsGoal.HOTEL_HAPPY_PAGE_SHOWN);
    }, []);

    if (!orderId) {
        return null;
    }

    if (isFailed) {
        return (
            <ErrorPage
                statusCode={errorResponse?.status}
                orderType={EProjectName.HOTELS}
                footerType={EFooterProject.HOTELS}
                orderId={orderId}
            />
        );
    }

    return (
        <HappyPageLayout
            orderType={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS_BOOKING}
            isLoading={!orderAndCrossSalesInfo}
        >
            {orderAndCrossSalesInfo && (
                <HappyPageContent
                    orderId={orderId}
                    orderAndCrossSalesInfo={orderAndCrossSalesInfo}
                />
            )}
        </HappyPageLayout>
    );
};

export default React.memo(HappyPage);
