import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWhiteLabelPoints} from 'server/api/OrdersAPI/types/TOrdersGetOrderHappyPageApiResponse';

import {deviceModMobile} from 'utilities/stylesUtils';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';

import * as i18nBlock from 'i18n/white-label-common';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

import cx from './WhiteLabelPartnerBanner.scss';

interface IBudapeshtBanner extends IWithDeviceType {
    points: IWhiteLabelPoints | undefined;
}

const WhiteLabelPartnerBanner: React.FC<IBudapeshtBanner> = props => {
    const {deviceType, points} = props;
    const {config} = useWhiteLabelConfig();

    if (!points?.amount) return null;

    const textTag = deviceType.isMobile ? undefined : 'div';

    return (
        <Flex
            className={cx('root', deviceModMobile('root', deviceType))}
            flexDirection={deviceType.isMobile ? 'column-reverse' : 'row'}
            alignItems={deviceType.isMobile ? 'flex-start' : 'center'}
            justifyContent="space-between"
        >
            <div>
                <Text className={cx('text')} tag={textTag} size="m">
                    {insertJSXIntoKey(i18nBlock.willBeAccruedInfo)({
                        points: points.amount,
                        name: points.pointsName,
                    })}
                </Text>
                <Text className={cx('text')} tag={textTag} size="m">
                    {i18nBlock.willBeAccruedText()}
                </Text>
            </div>
            <img
                src={config?.loyaltyLogo}
                alt=""
                className={cx('icon', deviceModMobile('icon', deviceType))}
            />
        </Flex>
    );
};

export default React.memo(WhiteLabelPartnerBanner);
