import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

/* Types */
import {IHotelSlugRouteMatch} from 'types/hotels/hotel/IHotelSlugRouteMatch';

/* Types */
import {
    getHotelInfoActions,
    GetHotelInfoActionType,
    resetHotelInfoToInitialAction,
    ResetHotelInfoToInitialActionType,
    getHotelInfoOffersActions,
    GetHotelInfoOffersActionType,
    getSimilarHotelsActions,
    GetSimilarHotelsActionType,
    getAdditionalHotelInfoAction,
    GetAdditionalHotelInfoActionType,
    setHotelInfoSearchParamsAction,
    SetHotelInfoSearchParamsActionType,
    stopHotelInfoActionsAction,
    StopHotelInfoActionsActionType,
} from 'reducers/hotels/hotelPage/hotelInfo/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {resetHotelsSearchFormAction} from 'reducers/hotels/searchForm/actions';
import {updateSearchInformation} from 'reducers/hotels/searchInformation/actions';
import {startHotelCalendarPricesPoolingAction} from 'reducers/hotels/hotelPage/calendarPrices/actions';

/* Selectors */

import hotelPageSelector from 'selectors/hotels/hotel/hotelPageSelector';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import {fetchHotelInfoSSR} from 'server/redux/hotels/fetchHotelInfo';

/* Components */

import HotelPage from './HotelPage';

/* Redux Maps */

const mapStateToProps = hotelPageSelector;

const mapDispatchToProps: IHotelPageDispatchContainer = {
    getHotelInfo: getHotelInfoActions.request,
    resetHotelInfoToInitial: resetHotelInfoToInitialAction,
    getAdditionalHotelInfo: getAdditionalHotelInfoAction,
    stopHotelInfoActions: stopHotelInfoActionsAction,
    getHotelInfoOffers: getHotelInfoOffersActions.request,
    getSimilarHotels: getSimilarHotelsActions.request,
    getCalendarPrices: startHotelCalendarPricesPoolingAction,
    setHotelInfoSearchParams: setHotelInfoSearchParamsAction,
    resetHotelsSearchForm: resetHotelsSearchFormAction,
    updateSearchInformation: updateSearchInformation,
};

type THotelPagePropsContainer = ReturnType<typeof hotelPageSelector>;

interface IHotelPageDispatchContainer {
    getHotelInfo: GetHotelInfoActionType;
    resetHotelInfoToInitial: ResetHotelInfoToInitialActionType;
    getAdditionalHotelInfo: GetAdditionalHotelInfoActionType;
    stopHotelInfoActions: StopHotelInfoActionsActionType;
    getHotelInfoOffers: GetHotelInfoOffersActionType;
    getCalendarPrices: () => void;
    getSimilarHotels: GetSimilarHotelsActionType;
    setHotelInfoSearchParams: SetHotelInfoSearchParamsActionType;
    resetHotelsSearchForm: typeof resetHotelsSearchFormAction;
    updateSearchInformation: typeof updateSearchInformation;
}

export type IHotelPageContainer = THotelPagePropsContainer &
    IHotelPageDispatchContainer &
    RouteComponentProps<IHotelSlugRouteMatch>;

export default _flow(
    withRouter,
    connect<
        THotelPagePropsContainer,
        IHotelPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    serverFetchDataDispatcher([fetchHotelInfoSSR]),
)(HotelPage);
