import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';
import {IHotelOrRoomImage} from 'types/hotels/hotel/IHotelImages';

import Gallery from './Gallery';

export default {
    title: 'Hotels/Gallery',
    component: Gallery,
} as Meta;

const IMAGES = [
    'https://avatars.mds.yandex.net/get-altay/200322/2a0000015b174a83f96cc29c10dcee720a7b/%s',
    'https://avatars.mds.yandex.net/get-altay/910613/2a000001616807388dd10d15df8296a88b38/%s',
    'https://avatars.mds.yandex.net/get-altay/1027639/2a000001616807b73142f7eb8f28c9dc38e7/%s',
    'https://avatars.mds.yandex.net/get-altay/965237/2a0000016522311954576637f757a21af51e/%s',
    'https://avatars.mds.yandex.net/get-altay/236825/2a0000015dcbd431c3c33ee93fa654960844/%s',
].map(
    (urlTemplate): IHotelOrRoomImage => ({
        id: '',
        sizes: [],
        tags: [],
        urlTemplate,
    }),
);

export const Single: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 1)}
        totalImageCount={1}
        onMoreImagesClick={noop}
    />
);

export const Double: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 2)}
        totalImageCount={2}
        onMoreImagesClick={noop}
    />
);

export const Triple: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 3)}
        totalImageCount={3}
        onMoreImagesClick={noop}
    />
);

export const Quadruple: TStorybookFunctionComponent = () => (
    <Gallery
        images={IMAGES.slice(0, 4)}
        totalImageCount={4}
        onMoreImagesClick={noop}
    />
);

export const Many: TStorybookFunctionComponent = () => (
    <Gallery images={IMAGES} totalImageCount={62} onMoreImagesClick={noop} />
);
