import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import GalleryRow from 'projects/hotels/pages/HotelPage/components/GalleryRow/GalleryRow';

import cx from './GalleryRow.stories.scss';

export default {
    title: 'Hotels/GalleryRow',
    component: GalleryRow,
} as Meta;

const IMAGES = [
    'https://avatars.mds.yandex.net/get-altay/200322/2a0000015b174a83f96cc29c10dcee720a7b/M',
    'https://avatars.mds.yandex.net/get-altay/910613/2a000001616807388dd10d15df8296a88b38/M',
    'https://avatars.mds.yandex.net/get-altay/1027639/2a000001616807b73142f7eb8f28c9dc38e7/M',
    'https://avatars.mds.yandex.net/get-altay/965237/2a0000016522311954576637f757a21af51e/M',
    'https://avatars.mds.yandex.net/get-altay/236825/2a0000015dcbd431c3c33ee93fa654960844/M',
];

export const Simple: TStorybookFunctionComponent = () => (
    <GalleryRow
        imageWrapperClassName={cx('image')}
        imageSources={IMAGES}
        onImageClick={noop}
    />
);

export const WithTotal: TStorybookFunctionComponent = () => (
    <GalleryRow
        imageWrapperClassName={cx('image')}
        imageSources={IMAGES}
        totalImageCount={1000}
        isLastClickable
        onImageClick={noop}
    />
);
