import {FunctionComponent, useCallback, useEffect} from 'react';

/* QA */
import {IHotel} from 'types/hotels/hotel/IHotel';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

/* Components */
import HotelImagesMobile from './components/HotelImagesMobile/HotelImagesMobile';
import HotelImagesDesktop from './components/HotelImagesDesktop/HotelImagesDesktop';

import {IHotelPageCardImagesTabContainer} from './HotelImagesContainer';

const DEFAULT_IMAGE_LIMIT = 20;

/* Component Types */
interface IHotelPageCardImagesTabProps
    extends IHotelPageCardImagesTabContainer {
    hotel: IHotel;
    isVisible: boolean;
    onCloseClick: () => void;
}

const HotelPageCardImagesTab: FunctionComponent<IHotelPageCardImagesTabProps> =
    props => {
        const {
            hotel,
            hotelImages: {data, isLoading},
            getHotelImages,
            isVisible,
            onCloseClick,
        } = props;

        const {isMobile} = useDeviceType();

        const getImages = useCallback(
            (itemsCount): void => {
                if (!isLoading && data.images.length < data.totalImageCount) {
                    getHotelImages({
                        imageOffset: data.images.length,
                        imageLimit: itemsCount,
                    });
                }
            },
            [getHotelImages, isLoading, data],
        );

        useEffect(() => {
            if (!isLoading && data.images.length === 0) {
                getHotelImages({
                    imageOffset: data.images.length,
                    imageLimit: DEFAULT_IMAGE_LIMIT,
                });
            }
        }, []);

        return isMobile ? (
            <HotelImagesMobile
                images={data.images}
                hotel={hotel}
                totalImageCount={data.totalImageCount}
                isLoading={isLoading}
                isVisible={isVisible}
                onMoreImages={getImages}
                onClose={onCloseClick}
            />
        ) : (
            <HotelImagesDesktop
                images={data.images}
                totalImageCount={data.totalImageCount}
                hotel={hotel}
                isLoading={isLoading}
                isVisible={isVisible}
                onMoreImages={getImages}
                onCloseClick={onCloseClick}
            />
        );
    };

export default HotelPageCardImagesTab;
