import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IHotel} from 'types/hotels/hotel/IHotel';

import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import HotelName from 'projects/hotels/components/HotelName/HotelName';
import HotelRatingWithLabel from 'projects/hotels/components/HotelRatingWithLabel/HotelRatingWithLabel';
import HotelStars from 'components/HotelStars/HotelStars';

interface IHotelImagesTitleProps extends IWithClassName {
    hotel: IHotel;
}

const HotelImagesTitle: FunctionComponent<IHotelImagesTitleProps> = ({
    className,
    hotel,
}) => {
    const {name: hotelName, stars, rating} = hotel;

    return (
        <Flex className={className} flexDirection="column" between={1}>
            <Heading level={2}>
                <HotelName
                    hotelName={hotelName}
                    icon={<HotelStars stars={stars} size="12" />}
                />
            </Heading>
            <HotelRatingWithLabel rating={rating} />
        </Flex>
    );
};

export default HotelImagesTitle;
