import {FunctionComponent, ReactNode} from 'react';

import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Intersperse from 'components/Intersperse/Intersperse';
import DotSeparator from 'components/DotSeparator/DotSeparator';
import RoomSize from 'projects/hotels/components/RoomSize/RoomSize';
import BedGroups from 'projects/hotels/components/BedGroups/BedGroups';
import Amenities from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenities/Amenities';
import HotelPageRoomDetailedInfoRedesign from 'projects/hotels/pages/HotelPage/components/HotelPageAllAmenities/blocks/HotelPageRoomDetailedInfo/HotelPageRoomDetailedInfo';

/* Styles */
import cx from './HotelPageAllAmenities.scss';

export interface IHotelPageRoomProps {
    room: IHotelRoom;
    onClose?: void;
}

const HotelPageAllAmenities: FunctionComponent<IHotelPageRoomProps> = ({
    room,
}) => {
    const {name, bedGroups, area, mainAmenities} = room;
    const deviceType = useDeviceType();

    function renderBedGroupsAndSize(): ReactNode {
        const bedGroupsNode = bedGroups?.length ? (
            <BedGroups
                bedGroups={bedGroups}
                canViewImage={false}
                bedClassName={cx('title')}
                isSeparatorBlock
            />
        ) : null;

        const roomSizeNode = area ? (
            <RoomSize className={cx('title')} area={area} />
        ) : null;

        if (!bedGroupsNode && !roomSizeNode) {
            return null;
        }

        return (
            <div className={cx('bedGroupsAndSize')}>
                <Intersperse separator={<DotSeparator />}>
                    {bedGroupsNode}
                    {roomSizeNode}
                </Intersperse>
            </div>
        );
    }

    function renderMainAmenities(): ReactNode {
        if (mainAmenities?.length) {
            return (
                <Amenities
                    className={cx('mainAmenities')}
                    amenities={mainAmenities}
                    viewType="table"
                    amenityTextSize="m"
                    amenityFontWeight="medium"
                    deviceType={deviceType}
                    itemsInRow={4}
                />
            );
        }

        return null;
    }

    function renderDetailedInfo(): ReactNode {
        return (
            <HotelPageRoomDetailedInfoRedesign
                className={cx('detailedInfo')}
                room={room}
            />
        );
    }

    return (
        <div className={cx('info')}>
            <h5 className={cx('name')}>{name}</h5>
            {renderBedGroupsAndSize()}
            {renderMainAmenities()}
            {renderDetailedInfo()}
        </div>
    );
};

export default HotelPageAllAmenities;
