import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

/* Components */
import DetailedInfoIcon from 'icons/16/DetailedInfo';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import AmenityGroups from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/AmenityGroups/AmenityGroups';

/* Styles */
import cx from './HotelPageRoomDetailedInfo.scss';

export interface IHotelPageRoomDetailedInfoProps extends IWithClassName {
    room: IHotelRoom;
}

const HotelPageRoomDetailedInfo: FunctionComponent<IHotelPageRoomDetailedInfoProps> =
    ({className, room}) => {
        const {description, amenityGroups} = room;

        if (!amenityGroups?.length && !description) {
            return null;
        }

        return (
            <div className={className}>
                <AmenityGroups
                    amenityGroups={amenityGroups}
                    amenityGroupNameFontWeight="medium"
                    amenityTextSize="m"
                    viewType="table"
                />
                {Boolean(description) && (
                    <TextWithIcon
                        className={cx('description')}
                        iconLeftClassName={cx('descriptionIcon')}
                        size="m"
                        text={description}
                        iconLeft={DetailedInfoIcon}
                    />
                )}
            </div>
        );
    };

export default HotelPageRoomDetailedInfo;
