import {connect} from 'react-redux';

import {
    getHotelImagesActions,
    GetHotelImagesActionType,
} from 'reducers/hotels/hotelPage/hotelImages/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {TSetSnackbarInfo} from 'reducers/common/snackbar/reducer';
import {setSnackbarInfo} from 'reducers/common/snackbar/actions';
import {
    changeHotelsIsFavoriteOnHotelPageActions,
    changeIsOpenForNoMoreFavoritesModalAction,
    ChangeHotelsIsFavoriteOnHotelPageType,
} from 'reducers/hotels/hotelPage/hotelInfo/actions';
import {
    removeFavoriteHotel,
    addFavoriteHotel,
} from 'reducers/hotels/hotelPage/hotelInfo/thunkActions';

import hotelImagesTabSelector, {
    IHotelImagesTabSelector,
} from 'selectors/hotels/hotel/imagesTab/hotelImagesTabSelector';
import experimentsSelector from 'selectors/common/experimentsSelector';

import HotelPageCard from './HotelPageCard';

const mapStateToProps = (store: StoreInterface) => ({
    ...hotelImagesTabSelector(store),
    noMoreFavoritesModalIsVisible:
        store.hotels.hotelPage.hotelInfo.noMoreFavoritesModalIsVisible,
    experiments: experimentsSelector(store),
});

interface IHotelPageCardStateContainer extends IHotelImagesTabSelector {
    noMoreFavoritesModalIsVisible?: boolean;
    experiments: ReturnType<typeof experimentsSelector>;
}

const mapDispatchToProps = {
    getHotelImages: getHotelImagesActions.request,
    /* Favorites */
    changeHotelsIsFavoriteAction:
        changeHotelsIsFavoriteOnHotelPageActions.request,
    removeFavoriteHotel: removeFavoriteHotel,
    addFavoriteHotel: addFavoriteHotel,
    setSnackbarInfo: setSnackbarInfo,
    changeIsOpenForNoMoreFavoritesModal:
        changeIsOpenForNoMoreFavoritesModalAction,
};

interface IHotelPageCardDispatchContainer {
    getHotelImages: GetHotelImagesActionType;
    /* Favorites */
    changeHotelsIsFavoriteAction: ChangeHotelsIsFavoriteOnHotelPageType;
    removeFavoriteHotel: typeof removeFavoriteHotel;
    addFavoriteHotel: typeof addFavoriteHotel;
    setSnackbarInfo: TSetSnackbarInfo;
    changeIsOpenForNoMoreFavoritesModal: typeof changeIsOpenForNoMoreFavoritesModalAction;
}

export type IHotelPageCardContainer = IHotelPageCardDispatchContainer &
    IHotelPageCardStateContainer;

export default connect<
    IHotelPageCardStateContainer,
    IHotelPageCardDispatchContainer,
    {},
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(HotelPageCard);
