import React from 'react';

import {EAdFoxBannerPosition, EAdFoxBannerType} from 'types/AdFox';
import {IWithClassName} from 'types/withClassName';
import {IHotelInfo} from 'server/api/HotelSearchAPI/types/IHotelInfo';
import {EHotelBanner} from 'server/api/HotelSearchAPI/types/IOffersInfo';

import {deviceModMobile} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import HotelOfferBanner from 'projects/hotels/components/HotelOfferBanner/HotelOfferBanner';
import AdFoxBanner from 'components/AdFoxBanner/AdFoxBanner';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelPageCardBanner.scss';

interface IHotelPageCardBannerProps extends IWithClassName, IWithQaAttributes {
    hotelInfo: IHotelInfo;
}

const HotelPageCardBanner: React.FC<IHotelPageCardBannerProps> = props => {
    const {className, hotelInfo} = props;
    const {
        offersInfo: {bannerType},
        hotel: {name},
    } = hotelInfo;

    const deviceType = useDeviceType();
    const {isWeb} = usePlatform();

    if (!isWeb) {
        return null;
    }

    const canRenderHotelOfferBanner =
        !bannerType || bannerType !== EHotelBanner.NONE;

    const rootCx = cx(className, 'root', deviceModMobile('root', deviceType));

    if (canRenderHotelOfferBanner) {
        return (
            <HotelOfferBanner
                className={rootCx}
                mirBannerClassName={cx('mirBanner')}
                bannerType={bannerType}
                hotelName={name}
                {...prepareQaAttributes(props)}
            />
        );
    }

    return (
        <AdFoxBanner
            className={rootCx}
            type={EAdFoxBannerType.Inline}
            position={EAdFoxBannerPosition.Center}
            fixed
        />
    );
};

export default HotelPageCardBanner;
