import React from 'react';

import {IWithClassName} from 'src/types/withClassName';
import {IHotelInfo} from 'reducers/hotels/hotelPage/hotelInfo/types';
import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';

import {IDevice} from 'reducers/common/commonReducerTypes';
import {GetHotelImagesActionType} from 'reducers/hotels/hotelPage/hotelImages/actions';

import {THotelImagesSelectorType} from 'selectors/hotels/hotel/imagesTab/getHotelImages';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import HotelPageCardMainTabMobile from 'projects/hotels/pages/HotelPage/components/HotelPageCardMainTab/blocks/HotelPageCardMainTabMobile/HotelPageCardMainTabMobile';
import HotelPageCardMainTabDesktop from 'projects/hotels/pages/HotelPage/components/HotelPageCardMainTab/blocks/HotelPageCardMainTabDesktop/HotelPageCardMainTabDesktop';

/* Component Types */
interface IHotelPageCardMainTabProps extends IWithClassName, IWithQaAttributes {
    hotelInfo: IHotelInfo;
    isLoadingOffers: boolean;
    onFavoritesClick: () => void;
    onOffersButtonClick: () => void;
    handleOfferWatchButtonClick: (roomId: string) => void;
    onReviewsButtonClick: () => void;
    onHotelAddressClick: () => void;
    onStaticMapClick: () => void;
    backButtonLink?: string;
    deviceType: IDevice;
    getHotelImages: GetHotelImagesActionType;
    hotelImages: THotelImagesSelectorType;
    reviewsRef: React.RefObject<HTMLDivElement>;
    withRoomsMatching?: boolean;
    region?: IGeoRegion;
}

const HotelPageCardMainTab: React.FC<IHotelPageCardMainTabProps> = props => {
    const {
        deviceType,
        hotelInfo,
        hotelImages,
        getHotelImages,
        handleOfferWatchButtonClick,
        onOffersButtonClick,
        onStaticMapClick,
        onReviewsButtonClick,
        reviewsRef,
        onHotelAddressClick,
        isLoadingOffers,
        onFavoritesClick,
        backButtonLink,
        region,
        ...qaProps
    } = props;
    const {isMobile} = deviceType;

    if (isMobile) {
        return (
            <HotelPageCardMainTabMobile
                onFavoritesClick={onFavoritesClick}
                hotelInfo={hotelInfo}
                hotelImages={hotelImages}
                getHotelImages={getHotelImages}
                onAddressClick={onHotelAddressClick}
                onReviewsButtonClick={onReviewsButtonClick}
                reviewsRef={reviewsRef}
                onOffersButtonClick={onOffersButtonClick}
                onOfferWatchButtonClick={handleOfferWatchButtonClick}
                isLoadingOffers={isLoadingOffers}
                backButtonLink={backButtonLink}
                region={region}
                {...prepareQaAttributes(qaProps)}
            />
        );
    }

    return (
        <HotelPageCardMainTabDesktop
            onMapClick={onStaticMapClick}
            hotelInfo={hotelInfo}
            hotelImages={hotelImages}
            getHotelImages={getHotelImages}
            reviewsRef={reviewsRef}
            onOffersButtonClick={onOffersButtonClick}
            onOfferWatchButtonClick={handleOfferWatchButtonClick}
            isLoadingOffers={isLoadingOffers}
            backButtonLink={backButtonLink}
            {...prepareQaAttributes(qaProps)}
        />
    );
};

export default React.memo(HotelPageCardMainTab);
