import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import HotelFeatures from 'projects/hotels/components/HotelReviews/components/HotelFeatures/HotelFeatures';
import Card from 'components/Card/Card';

import cx from './HotelFeaturesMobile.scss';

interface IHotelFeaturesMobileProps extends IWithClassName {}

const HotelFeaturesMobile: FC<IHotelFeaturesMobileProps> = ({className}) => {
    return (
        <HotelFeatures
            wrapperComponent={Card}
            className={cx('root', className)}
        />
    );
};

export default HotelFeaturesMobile;
