import React from 'react';

import {IHotelInfo} from 'server/api/HotelSearchAPI/types/IHotelInfo';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {IWithClassName} from 'types/withClassName';
import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useReachGoal} from 'utilities/metrika/useReachGoal';

import OffersInfo from 'projects/hotels/pages/HotelPage/components/OffersInfo/OffersInfo';

interface IHotelPageOffersInfoProps extends IWithClassName {
    hotelInfo: IHotelInfo;
    roomsRef?: React.RefObject<HTMLDivElement>;
    isLoadingOffers: boolean;
    withRoomsMatching?: boolean;
    backButtonLink?: string;
    onOffersButtonClick: () => void;
    onOfferWatchButtonClick: (roomId: string) => void;
    region?: IGeoRegion;
}

const HotelPageOffersInfo: React.FC<IHotelPageOffersInfoProps> = ({
    hotelInfo,
    isLoadingOffers,
    withRoomsMatching,
    roomsRef,
    backButtonLink,
    onOffersButtonClick,
    onOfferWatchButtonClick,
    className,
    region,
}) => {
    const {offersInfo, searchParams} = hotelInfo;

    const deviceType = useDeviceType();

    const handleOfferSelect = useReachGoal(
        EHotelsGoal.HOTEL_PAGE_MAIN_TAB_OFFER_CLICK,
    );

    return (
        <OffersInfo
            className={className}
            roomsRef={roomsRef}
            offersInfo={offersInfo}
            searchParams={searchParams}
            deviceType={deviceType}
            backButtonLink={backButtonLink}
            isFullOffersTab
            onFilterSelect={onOffersButtonClick}
            onAllOffersClick={onOffersButtonClick}
            onOfferSelect={handleOfferSelect}
            onOfferWatchButtonClick={onOfferWatchButtonClick}
            isLoading={isLoadingOffers}
            withRoomsMatching={withRoomsMatching}
            region={region}
            {...prepareQaAttributes('hotelOffersInfo')}
        />
    );
};

export default HotelPageOffersInfo;
