import {FC} from 'react';

import {IHotelInfo} from 'server/api/HotelSearchAPI/types/IHotelInfo';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {deviceMods} from 'utilities/stylesUtils';

import SimilarHotels from 'projects/hotels/components/SimilarHotels/SimilarHotels';
import Card from 'components/Card/Card';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelPageSimilarHotels.scss';

interface IHotelPageSimilarHotelsProps extends IWithClassName {
    hotelInfo: IHotelInfo;
}

const HotelPageSimilarHotels: FC<IHotelPageSimilarHotelsProps> = ({
    hotelInfo,
    className,
}) => {
    const {similarHotelsInfo, searchParams} = hotelInfo;

    const {isWeb} = usePlatform();
    const deviceType = useDeviceType();

    const handleClickSimilarHotel = useReachGoal(
        EHotelsGoal.HOTEL_PAGE_MAIN_TAB_SIMILAR_HOTEL_CLICK,
    );

    if (!isWeb) {
        return null;
    }

    if (!similarHotelsInfo?.hotels?.length) {
        return null;
    }

    const Wrapper = deviceType.isMobile ? Card : 'div';

    return (
        <Wrapper
            className={cx('root', deviceMods('root', deviceType), className)}
        >
            <SimilarHotels
                similarHotelsInfo={similarHotelsInfo}
                onClickCard={handleClickSimilarHotel}
                searchParams={searchParams}
                deviceType={deviceType}
            />
        </Wrapper>
    );
};

export default HotelPageSimilarHotels;
