import {IHotel} from 'types/hotels/hotel/IHotel';
import {IWithClassName} from 'types/withClassName';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useReachGoal} from 'utilities/metrika/useReachGoal';
import {useExperiments} from 'utilities/hooks/useExperiments';
import {getHotelUrlOnYandexMaps} from 'utilities/url/getYandexMapsUrl';

import YandexMaps, {
    useYandexMapInstance,
} from 'components/YandexMaps/YandexMaps';

import HotelPageMapMarker from '../HotelPageMapMarker/HotelPageMapMarker';

import cx from './HotelPageCardMap.scss';

interface IHotelPageCardMapTabProps extends IWithClassName, IWithQaAttributes {
    hotel: IHotel;
    canRenderAddress: boolean;
    deviceType: IDevice;
}

const MAP_QA = 'map';
const MAP_PROVIDER_QUERY = {
    ns: 'use-load-map-tab',
    load: 'package.full',
};

const HotelPageCardMap = (props: IHotelPageCardMapTabProps) => {
    const {className, hotel, canRenderAddress, deviceType} = props;
    const {coordinates} = hotel;
    const [yandexMapAPIInstance, handleMapLoad] = useYandexMapInstance();
    const {hotelsHotelsPageMapTransport} = useExperiments();
    const handleRouteExpand = useReachGoal(
        EHotelsGoal.HOTELS_HOTEL_PAGE_MAP_TRANSPORT_CLICK,
    );
    const handleBigMapClick = useReachGoal(
        EHotelsGoal.HOTELS_HOTEL_PAGE_MAP_BIGMAP_CLICK,
    );

    return (
        <div
            className={className}
            {...prepareQaAttributes({
                parent: props,
                current: MAP_QA,
            })}
        >
            <YandexMaps
                defaultCenter={coordinates}
                onLoadMap={handleMapLoad}
                providerQuery={MAP_PROVIDER_QUERY}
                customControlsClassName={cx(deviceMods('controls', deviceType))}
                hasZoomControl
                hasGeoLocationControl
                yandexMapsUrl={getHotelUrlOnYandexMaps({
                    hotelId: hotel.permalink,
                    coordinates: coordinates,
                })}
                hasRoutePanel={hotelsHotelsPageMapTransport}
                onRoutePanelExpand={handleRouteExpand}
                onYandexMapsOpen={handleBigMapClick}
            >
                <HotelPageMapMarker
                    className={cx('mapMarker')}
                    hotel={hotel}
                    yandexMapAPIInstance={yandexMapAPIInstance}
                    canRenderAddress={canRenderAddress}
                    {...prepareQaAttributes(MAP_QA)}
                />
            </YandexMaps>
        </div>
    );
};

export default HotelPageCardMap;
