import React from 'react';

import {PRODUCTION_PROJECT_URL} from 'constants/common';

import {IHotelSeoInfo} from 'types/hotels/hotel/ISeoInfo';
import {IHotel} from 'types/hotels/hotel/IHotel';

import {hotelsURLs} from 'projects/hotels/utilities/urls';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';

interface IOwnProps {
    hotel: IHotel;
    seoInfo: IHotelSeoInfo;
}

/**
 * Хелмет для страницы отеля.
 */
const HotelPageHelmet: React.FC<IOwnProps> = props => {
    const {seoInfo, hotel} = props;

    const {title, description} = seoInfo;

    const hotelSlug = hotel?.hotelSlug;
    const hotelPageUrlWithSlug = hotelSlug
        ? `${PRODUCTION_PROJECT_URL}${hotelsURLs.getHotelUrl({hotelSlug})}`
        : '';

    return (
        <DocumentMeta
            title={title}
            description={description}
            canonicalUrl={hotelPageUrlWithSlug}
        />
    );
};

export default HotelPageHelmet;
