import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import RoundButton from 'components/RoundButton/RoundButton';
import ArrowLeftIcon from 'icons/16/ArrowLeft';
import ArrowRightIcon from 'icons/16/ArrowRight';

interface IControlButtonProps extends IWithClassName, IWithQaAttributes {
    type: 'next' | 'prev';
    onClick: () => void;
}

const ControlButton: FunctionComponent<IControlButtonProps> = ({
    className,
    type,
    onClick,
    ...rest
}) => {
    const icon = type === 'next' ? <ArrowRightIcon /> : <ArrowLeftIcon />;

    return (
        <span className={className} {...prepareQaAttributes(rest)}>
            <RoundButton size="m" theme="dark" onClick={onClick} icon={icon} />
        </span>
    );
};

export default ControlButton;
