import {ReactNode, useMemo} from 'react';
import {useSelector} from 'react-redux';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'src/types/withClassName';
import {EFooterProject} from 'components/Footer/types';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import {getHotelCalendarPrices} from 'selectors/hotels/hotel/getHotelCalendarPrices';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import LayoutDefault, {
    ELayoutBgColor,
} from 'components/Layouts/LayoutDefault/LayoutDefault';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelPageLayout.scss';

interface IHotelPageLayoutProps extends IWithClassName {
    isHeaderShown?: boolean;
    isFooterShown?: boolean;
    children: ReactNode;
    searchFormCollapsedClassName?: string;
}

const HotelPageLayout: React.FC<IHotelPageLayoutProps> = props => {
    const {
        className,
        searchFormCollapsedClassName,
        isHeaderShown,
        isFooterShown,
        children,
    } = props;
    const deviceType = useDeviceType();
    const {isWeb} = usePlatform();
    const {data: calendarPrices} = useSelector(getHotelCalendarPrices);

    const searchFormProps = useMemo(() => ({calendarPrices}), [calendarPrices]);

    return (
        <LayoutDefault
            className={className}
            bgColor={
                deviceType.isMobile ? ELayoutBgColor.DARK : ELayoutBgColor.LIGHT
            }
            contentClassName={cx('content')}
            footerClassName={cx('footer')}
            footerWrapperClassName={cx(
                deviceType.isDesktop && 'footer_wrapper',
            )}
            searchFormCollapsedClassName={searchFormCollapsedClassName}
            isFixedNavigation
            showNavigation
            showSearchForm
            hasSideSheetNavigation
            searchFormInitialIsExpanded={false}
            project={EProjectName.HOTELS}
            footerType={EFooterProject.HOTELS}
            showHeader={isWeb && isHeaderShown}
            showFooter={isWeb && isFooterShown}
            headerBorderBottomType={
                deviceType.isMobile
                    ? EHeaderBorderBottomType.NONE
                    : EHeaderBorderBottomType.FULL
            }
            searchFormProps={searchFormProps}
        >
            {children}
        </LayoutDefault>
    );
};

export default HotelPageLayout;
