import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    HotelOffersFiltersType,
    FilterType,
    FilterKeyType,
} from 'reducers/hotels/hotelPage/hotelInfo/types';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import getFilterText from './utilities/getFilterText';

/* Components */
import CheckButton from 'components/CheckButton/CheckButton';
import Box from 'components/Box/Box';

type TFiltersDisable = HotelOffersFiltersType;

export interface IHotelPageOfferFiltersProps extends IWithClassName {
    itemClassName?: string;
    filters: HotelOffersFiltersType;
    onFilterSelect: (filter: FilterType) => void;
    disabledFilters?: TFiltersDisable;
}

const HotelPageOfferFilters: FunctionComponent<IHotelPageOfferFiltersProps> = ({
    className,
    itemClassName,
    filters,
    onFilterSelect,
    disabledFilters,
}) => {
    const filterKeys = Object.keys(FilterType) as FilterKeyType[];

    return (
        <Box
            className={className}
            between={2}
            inline
            {...prepareQaAttributes('hotelPageOfferFilters')}
        >
            {filterKeys.map(filterKey => {
                const filter = FilterType[filterKey];
                const filterValue = filters[filter];
                const isDisabled = !filterValue && disabledFilters?.[filter];

                return (
                    <CheckButton
                        key={filterKey}
                        className={itemClassName}
                        checked={filterValue}
                        disabled={isDisabled}
                        onClick={(): void => onFilterSelect(filter)}
                        {...prepareQaAttributes(filter)}
                    >
                        {getFilterText(filter)}
                    </CheckButton>
                );
            })}
        </Box>
    );
};

export default HotelPageOfferFilters;
