import {ReactRouterLocationType} from 'types/common/IReactRouterLocation';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {IBaseSearchQueryParams} from 'types/hotels/common/IQueryParams';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';
import {getOfferSearchQueryParams} from 'projects/hotels/utilities/getRequiredOfferSearchQuery/getRequiredOfferSearchQuery';

/* Constants */
const CHECK_SEARCH_PARAM_LIST: (keyof IBaseSearchQueryParams)[] = [
    'checkinDate',
    'checkoutDate',
    'adults',
    'childrenAges',
];

export const checkDifferenceBetweenQueryAndSearchParams = ({
    location,
    searchParams,
}: {
    location: ReactRouterLocationType;
    searchParams?: IRequiredOfferParams;
}): boolean => {
    const queryByLocation = getQueryByLocation(location);
    const queryBySearchParams = getOfferSearchQueryParams(searchParams);

    if (queryBySearchParams) {
        return !CHECK_SEARCH_PARAM_LIST.every(paramKey => {
            const queryParamBySearchInfo = queryBySearchParams[paramKey];
            const convertedQueryParamBySearchInfo = queryParamBySearchInfo
                ? String(queryBySearchParams[paramKey])
                : undefined;
            const queryParamByLocation = queryByLocation[paramKey];
            const convertedQueryParamByLocation = queryParamByLocation
                ? queryParamByLocation
                : undefined;

            return (
                convertedQueryParamByLocation ===
                convertedQueryParamBySearchInfo
            );
        });
    }

    return false;
};
