import {
    ReactRouterLocationType,
    ReactRouterMatchType,
} from 'types/common/IReactRouterLocation';
import {HotelSlugType, PermalinkType} from 'types/hotels/hotel/IHotel';
import {IHotelSlugRouteMatch} from 'types/hotels/hotel/IHotelSlugRouteMatch';

import getQueryByLocation from 'utilities/getQueryByLocation/getQueryByLocation';
import {getHotelSlugByRouteMatch} from 'projects/hotels/utilities/getHotelIdentifier/getHotelIdentifier';

export const checkDifferenceBetweenRouterAndHotelIdentifier = ({
    match,
    location,
    permalink,
    hotelSlug,
}: {
    match: ReactRouterMatchType<IHotelSlugRouteMatch>;
    location: ReactRouterLocationType;
    permalink?: PermalinkType;
    hotelSlug?: HotelSlugType;
}): boolean => {
    const {hotelPermalink} = getQueryByLocation(location);
    const hotelSlugByRouteMatch = getHotelSlugByRouteMatch(match);

    if (permalink && hotelPermalink) {
        return permalink !== hotelPermalink;
    }

    if (hotelSlug && hotelSlugByRouteMatch) {
        return hotelSlug !== hotelSlugByRouteMatch;
    }

    return true;
};
