import React from 'react';

import {IBreadcrumbs} from 'reducers/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'src/types/withClassName';

import {hotelsURLs} from 'projects/hotels/utilities/urls';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModMobile} from 'utilities/stylesUtils';
import {getBreadcrumbInfo} from 'projects/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-GeoRegionPage';

import LinkBreadcrumbs from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelPageSeoBreadCrumbs.scss';

export interface IHotelPageSeoBreadCrumbsProps extends IWithClassName {
    breadcrumbs: IBreadcrumbs;
    nonce: string;
}

const HotelPageSeoBreadCrumbs: React.FC<IHotelPageSeoBreadCrumbsProps> = (
    props: IHotelPageSeoBreadCrumbsProps,
) => {
    const {
        breadcrumbs: {items},
        breadcrumbs,
        className,
        nonce,
    } = props;
    const deviceType = useDeviceType();
    const {isWeb} = usePlatform();

    if (!isWeb) {
        return null;
    }

    return (
        <LinkBreadcrumbs
            className={cx(
                'root',
                deviceModMobile('root', deviceType),
                className,
            )}
            scrollableClassName={cx('scrollable')}
            nonce={nonce}
        >
            <LinkBreadcrumbs.Item
                url={hotelsURLs.getHotelsRootUrl()}
                metaUrl={hotelsURLs.getAbsoluteHotelUrl({slug: ''})}
            >
                {i18nBlock.breadCrumbHotel()}
            </LinkBreadcrumbs.Item>

            {items.map((breadcrumb, index) => {
                const {text, link} = getBreadcrumbInfo(breadcrumb, breadcrumbs);

                return (
                    <LinkBreadcrumbs.Item
                        key={breadcrumb.slug}
                        url={index === items.length - 1 ? undefined : link}
                        metaUrl={hotelsURLs.getAbsoluteHotelUrl({
                            slug: breadcrumb.slug,
                        })}
                        {...prepareQaAttributes({
                            current: 'hotelPageBreadcrumb',
                            key: index,
                        })}
                    >
                        {text}
                    </LinkBreadcrumbs.Item>
                );
            })}
        </LinkBreadcrumbs>
    );
};

export default React.memo(HotelPageSeoBreadCrumbs);
