import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import IPrice from 'utilities/currency/PriceInterface';

import * as i18nBlock from 'i18n/hotels-HotelPage';

import BorderPositioned from 'components/BorderPositioned/BorderPositioned';
import SellIcon from 'icons/24/Sell';
import Button from 'components/Button/Button';
import Price from 'components/Price/Price';

import cx from './HotelPageSummaryOffersButton.scss';

interface IOffersButtonProps extends IWithClassName {
    minPrice?: IPrice;
    hasDiscount?: boolean;

    onClick: () => void;
}

const HotelPageSummaryOffersButton: FC<IOffersButtonProps> = ({
    hasDiscount,
    minPrice,
    onClick,
    className,
}) => {
    if (!minPrice) {
        return null;
    }

    return (
        <BorderPositioned
            className={cx('root', className)}
            badge={
                hasDiscount && (
                    <SellIcon className={cx('icon')} width="24" height="24" />
                )
            }
        >
            <Button size="l" theme="primary" width="max" onClick={onClick}>
                {insertJSXIntoKey(i18nBlock.chooseRoomFromPrice)({
                    price: <Price key="viewAllOffers" {...minPrice} />,
                })}
            </Button>
        </BorderPositioned>
    );
};

export default HotelPageSummaryOffersButton;
