import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useToggle} from 'utilities/hooks/useToggle';

/* Components */
import LinkButton from 'components/LinkButton/LinkButton';
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';
import RotatingArrowIcon from 'components/RotatingArrowIcon/RotatingArrowIcon';

/* Styles */
import cx from './HotelPageToggleInfo.scss';

export interface IHotelPageToggleInfoProps extends IWithClassName {
    toggleButtonText: string;
    toggleLinkClassName?: string;
}

const HotelPageToggleInfo: FunctionComponent<IHotelPageToggleInfoProps> = ({
    className,
    toggleLinkClassName,
    children,
    toggleButtonText,
}) => {
    const [isVisible, toggleVisibility] = useToggle(false);

    return (
        <div className={className}>
            <LinkButton
                className={toggleLinkClassName}
                onClick={toggleVisibility}
            >
                {toggleButtonText}
                <RotatingArrowIcon
                    className={cx('arrowIcon')}
                    rotated={isVisible}
                />
            </LinkButton>
            <AutoHeightAnimateControl canShowComponent={isVisible}>
                {children}
            </AutoHeightAnimateControl>
        </div>
    );
};

export default HotelPageToggleInfo;
