import React, {useCallback, useMemo} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import EPopupDirection from 'components/Popup/types/EPopupDirection';
import {IWithClassName} from 'types/withClassName';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {deviceMods} from 'utilities/stylesUtils';
import prepareShareURL from 'projects/hotels/pages/HotelPage/components/HotelShareButton/utilities/prepareShareURL';
import {reachGoal} from 'utilities/metrika';

import IconL from 'icons/36/ShareOutline';
import IconM from 'icons/24/ShareOutline';
import Share from 'components/Share/Share';

import cx from './HotelShareButton.scss';

interface IHotelShareButtonProps extends IWithDeviceType, IWithClassName {
    size: 'm' | 'l';
}

const icons = {
    l: IconL,
    m: IconM,
};

const HotelShareButton: React.FC<IHotelShareButtonProps> = ({
    size,
    deviceType,
    className,
}) => {
    const link = prepareShareURL();

    const hitOpenGoal = useCallback(() => {
        reachGoal(EHotelsGoal.HOTEL_PAGE_SHARE_CLICK);
    }, []);

    const hitShareGoal = useCallback(() => {
        reachGoal(EHotelsGoal.HOTEL_PAGE_SHARE_SHARED);
    }, []);

    const button = useMemo(() => {
        const Icon = icons[size];

        return (
            <div
                className={cx(
                    'root',
                    `root_size_${size}`,
                    deviceMods('root', deviceType),
                    className,
                )}
            >
                <Icon className={cx('icon')} />
            </div>
        );
    }, [size, className, deviceType]);

    return (
        <Share
            onClick={hitOpenGoal}
            onCopyLinkClick={hitShareGoal}
            onShareLinkClick={hitShareGoal}
            button={button}
            link={link}
            popupDirections={[EPopupDirection.BOTTOM]}
            page="hotel"
        />
    );
};

export default HotelShareButton;
