const ALLOW_LIST = [
    'adults',
    'checkinDate',
    'checkoutDate',
    'childrenAges',
    'searchPagePollingId',
];

const prepareShareURL = (): string => {
    if (typeof window === 'undefined' || !window.location) {
        return '';
    }

    const url = new URL(window.location.toString());

    const urlParams = url.searchParams;

    urlParams.forEach((_, key) => {
        if (ALLOW_LIST.includes(key)) {
            return;
        }

        urlParams.delete(key);
    });

    return url.toString();
};

export default prepareShareURL;
