import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Heading from 'components/Heading/Heading';
import Favorites from 'projects/hotels/components/Favorites/Favorites';
import HotelName from 'projects/hotels/components/HotelName/HotelName';
import HotelShareButton from 'projects/hotels/pages/HotelPage/components/HotelShareButton/HotelShareButton';
import HotelStars from 'components/HotelStars/HotelStars';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './HotelTitle.scss';

export interface IHotelTitleProps extends IWithDeviceType, IWithClassName {
    name: string;
    isFavorite: boolean;
    handleFavoriteClick: () => void;
    stars?: number;
}

const HotelTitle: React.FC<IHotelTitleProps> = ({
    name,
    isFavorite,
    handleFavoriteClick,
    stars,
    deviceType,
    className,
}) => {
    const {isWeb} = usePlatform();

    return (
        <Heading
            level={1}
            className={cx(
                'hotelName',
                deviceMods('hotelName', deviceType),
                className,
            )}
            {...prepareQaAttributes('hotelName')}
        >
            <div className={cx('nameWrapper')}>
                <HotelName
                    hotelName={name}
                    icon={<HotelStars stars={stars} size="16" />}
                />
            </div>

            <div className={cx('actions', deviceMods('actions', deviceType))}>
                {isWeb && (
                    <HotelShareButton
                        className={cx(
                            'shareIcon',
                            deviceMods('shareIcon', deviceType),
                        )}
                        deviceType={deviceType}
                        size={deviceType.isDesktop ? 'l' : 'm'}
                    />
                )}

                {isWeb && (
                    <Favorites
                        className={cx('heartIcon')}
                        onClick={handleFavoriteClick}
                        isFavorite={isFavorite}
                        size={deviceType.isDesktop ? 'l' : 'm'}
                        deviceType={deviceType}
                    />
                )}
            </div>
        </Heading>
    );
};

export default HotelTitle;
