import {FunctionComponent} from 'react';

import {IHotelsOperator} from 'types/hotels/offer/IHotelsOperator';
import {IWithClassName} from 'types/withClassName';

import IPrice from 'utilities/currency/PriceInterface';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import HotelOperator from 'projects/hotels/components/HotelOperator/HotelOperator';
import Price from 'components/Price/Price';
import ButtonLink from 'components/ButtonLink/ButtonLink';
import InNewTabIcon from 'icons/16/InNewTab';
import Flex from 'components/Flex/Flex';

import cx from './MatchedOffer.scss';

interface IMatchedOfferProps extends IWithClassName {
    operator: IHotelsOperator;
    partnerUrl: string;
    price: IPrice;
}

const MatchedOffer: FunctionComponent<IMatchedOfferProps> = ({
    className,
    operator,
    partnerUrl,
    price,
}) => {
    const deviceType = useDeviceType();
    const {isMobile} = deviceType;

    return (
        <Flex
            className={cx('root', deviceMods('root', deviceType), className)}
            alignItems={isMobile ? 'flex-end' : 'center'}
            justifyContent="space-between"
        >
            <Flex
                className={cx('operatorAndPrice')}
                flexDirection={isMobile ? 'column' : 'row'}
            >
                <HotelOperator
                    className={cx('operator')}
                    operator={operator}
                    partnerUrl={partnerUrl}
                    theme="black"
                    size="l"
                />
                <Price className={cx('price')} {...price} />
            </Flex>
            <ButtonLink
                className={cx('button')}
                url={partnerUrl}
                target="_blank"
            >
                <InNewTabIcon />
            </ButtonLink>
        </Flex>
    );
};

export default MatchedOffer;
