import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModDesktop, deviceModMobile} from 'utilities/stylesUtils';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Separator from 'components/Separator/Separator';

import cx from './MainOffersSkeleton.scss';

const MainOfferSkeletonMobile: React.FC = () => (
    <div className={cx('offer')}>
        <div className={cx('top')}>
            <div className={cx('topText')}>
                <div className={cx('title')} />
                <div className={cx('title')} />
                <div className={cx('text')} />
            </div>
            <div className={cx('image')} />
        </div>
        <div className={cx('textBlock')}>
            <div className={cx('text')} />
            <div className={cx('text')} />
        </div>
    </div>
);

interface IMainOfferSkeletonDesktop {
    isFullOffersTab?: boolean;
}

const MainOfferSkeletonDesktop: React.FC<IMainOfferSkeletonDesktop> = ({
    isFullOffersTab,
}) => (
    <div className={cx('offer')}>
        <div className={cx('top')}>
            <div className={cx('topText')}>
                <div className={cx('title')} />
                {!isFullOffersTab && <div className={cx('title')} />}
                <div className={cx('text')} />
            </div>
            {!isFullOffersTab && <div className={cx('image')} />}
        </div>
        {!isFullOffersTab && (
            <div className={cx('textBlock')}>
                <div className={cx('text')} />
            </div>
        )}
        <div className={cx('bottomText')}>
            <div className={cx('text')} />
            {isFullOffersTab && (
                <>
                    <div className={cx('text')} />
                    <div className={cx('button')} />
                </>
            )}
        </div>
    </div>
);

interface IMainOffersSkeleton extends IWithClassName {
    isFullOffersTab?: boolean;
}

const MainOffersSkeleton: React.FC<IMainOffersSkeleton> = ({
    className,
    isFullOffersTab,
}) => {
    const deviceType = useDeviceType();

    if (deviceType.isMobile) {
        return (
            <div
                className={cx(
                    'root',
                    deviceModMobile('root', deviceType),
                    className,
                )}
            >
                <CardWithDeviceLayout shadow="none">
                    <MainOfferSkeletonMobile />
                    <Separator />
                    <MainOfferSkeletonMobile />
                    <Separator />
                    <MainOfferSkeletonMobile />
                    <Separator />
                    <MainOfferSkeletonMobile />
                </CardWithDeviceLayout>
            </div>
        );
    }

    return (
        <div
            className={cx(
                'root',
                deviceModDesktop('root', deviceType),
                className,
                {
                    root_isFull: isFullOffersTab,
                },
            )}
        >
            <MainOfferSkeletonDesktop isFullOffersTab={isFullOffersTab} />
            <MainOfferSkeletonDesktop isFullOffersTab={isFullOffersTab} />
            <MainOfferSkeletonDesktop isFullOffersTab={isFullOffersTab} />
            {!isFullOffersTab && <MainOfferSkeletonDesktop />}
        </div>
    );
};

export default MainOffersSkeleton;
