import {IRoomAmenity} from 'types/hotels/offer/IHotelRoom';
import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';

import MoreButton from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenities/components/MoreButton/MoreButton';
import MainAmenities from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenities/components/MainAmenities/MainAmenities';

import cx from './Amenities.scss';

export interface IHotelPageRoomAmenitiesProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    amenities?: IRoomAmenity[];
    amenityLimit?: number;
    viewType: 'table' | 'column' | 'inline';
    amenityTextSize: 's' | 'm';
    amenityFontWeight: 'normal' | 'medium' | 'bold';
    handleMoreInfoClick?: () => void;
    renderMoreButton?: boolean;
    hideFeatures?: boolean;
    itemsInRow?: 3 | 4 | 8;
}

const Amenities: React.FC<IHotelPageRoomAmenitiesProps> = ({
    deviceType,
    className,
    viewType,
    amenities,
    renderMoreButton,
    handleMoreInfoClick,
    amenityFontWeight,
    amenityTextSize,
    amenityLimit,
    itemsInRow,
    hideFeatures,
    ...restProps
}) => {
    if (!amenities?.length) {
        return null;
    }

    return (
        <section
            className={cx(
                'root',
                {
                    [`root_view_${viewType}`]: Boolean(viewType),
                },
                className,
            )}
            {...prepareQaAttributes(restProps)}
        >
            <MainAmenities
                rowClassName={cx('amenityRow')}
                amenityClassName={cx(
                    'amenity',
                    `amenity${deviceType.isMobile ? '' : itemsInRow}`,
                )}
                viewType={viewType}
                amenities={amenities}
                deviceType={deviceType}
                amenityTextSize={amenityTextSize}
                amenityFontWeight={amenityFontWeight}
                hideFeatures={hideFeatures}
                itemsInRow={itemsInRow}
            />
            {renderMoreButton && (
                <MoreButton
                    className={cx(
                        'moreButton',
                        deviceMods('moreButton', deviceType),
                    )}
                    deviceType={deviceType}
                    handleMoreInfoClick={handleMoreInfoClick}
                    {...prepareQaAttributes(restProps)}
                />
            )}
        </section>
    );
};

export default Amenities;
