import _chunk from 'lodash/chunk';
import {useCallback} from 'react';

import {TOTAL_ITEMS_IN_ROW} from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenities/constants';

import {IRoomAmenity} from 'types/hotels/offer/IHotelRoom';
import {IWithDeviceType} from 'types/withDeviceType';

import Amenity from 'projects/hotels/pages/HotelPage/components/OffersInfo/components/Rooms/components/Amenity/Amenity';

interface IMainAmenitiesProps extends IWithDeviceType {
    amenityClassName?: string;
    rowClassName?: string;
    viewType: 'table' | 'column' | 'inline';
    amenities: IRoomAmenity[];
    amenityTextSize: 's' | 'm';
    amenityFontWeight: 'normal' | 'medium' | 'bold';
    amenityLimit?: number;
    itemsInRow?: 3 | 4 | 8;
    hideFeatures?: boolean;
}

const MainAmenities: React.FC<IMainAmenitiesProps> = ({
    viewType,
    amenities,
    itemsInRow = TOTAL_ITEMS_IN_ROW,
    amenityLimit,
    amenityTextSize,
    amenityFontWeight,
    deviceType,
    hideFeatures,
    amenityClassName,
    rowClassName,
}) => {
    const renderer = useCallback(
        amenity => {
            return (
                <Amenity
                    key={amenity.id}
                    amenity={amenity}
                    className={amenityClassName}
                    amenityTextSize={amenityTextSize}
                    amenityFontWeight={amenityFontWeight}
                    hideFeatures={hideFeatures}
                    hasPopup={hideFeatures && deviceType.isDesktop}
                />
            );
        },
        [
            amenityClassName,
            amenityFontWeight,
            amenityTextSize,
            deviceType.isDesktop,
            hideFeatures,
        ],
    );

    switch (viewType) {
        case 'table': {
            const amenityRows = _chunk(amenities, itemsInRow);

            return (
                <>
                    {amenityRows.map((amenityRow, index) => (
                        <div key={index} className={rowClassName}>
                            {amenityRow.map(renderer)}
                        </div>
                    ))}
                </>
            );
        }

        case 'column': {
            return <>{amenities.slice(0, amenityLimit).map(renderer)}</>;
        }

        case 'inline': {
            return <>{amenities.slice(0, amenityLimit).map(renderer)}</>;
        }

        default: {
            return null;
        }
    }
};

export default MainAmenities;
