import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import LinkButton from 'components/LinkButton/LinkButton';

interface IMoreButtonProps
    extends IWithDeviceType,
        IWithQaAttributes,
        IWithClassName {
    handleMoreInfoClick?: () => void;
}

const MoreButton: React.FC<IMoreButtonProps> = ({
    handleMoreInfoClick,
    deviceType,
    className,
    ...restProps
}) => {
    return (
        <LinkButton
            className={className}
            onClick={handleMoreInfoClick}
            {...prepareQaAttributes({
                parent: restProps,
                current: 'moreButton',
            })}
        >
            {deviceType.isMobile
                ? i18nBlock.moreInformationAboutRoom()
                : i18nBlock.viewAllAmenities()}
        </LinkButton>
    );
};

export default MoreButton;
