import React, {ReactNode} from 'react';

import {IHotelBoyMetaRoomWithOffers} from 'reducers/hotels/hotelPage/hotelInfo/types';
import {IWithClassName} from 'types/withClassName';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceModMobile} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import NoHotelPhotoM from 'icons/illustrations/NoHotelPhoto/NoHotelPhotoM';
import Heading from 'components/Heading/Heading';
import RotatingArrowIcon, {
    IRotatingArrowIconProps,
} from 'components/RotatingArrowIcon/RotatingArrowIcon';
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';
import Card from 'components/Card/Card';

import cx from './RoomsWithoutOffers.scss';

interface IHotemPageRoomsWithoutOffersProps
    extends IWithClassName,
        IWithQaAttributes {
    rooms: IHotelBoyMetaRoomWithOffers[];
    renderRoom: (room: IHotelBoyMetaRoomWithOffers) => ReactNode;
    contentClassName?: string;
}

const ICON_PROPS_MOBILE: Pick<IRotatingArrowIconProps, 'width' | 'height'> = {
    width: 24,
    height: 24,
};

const RoomsWithoutOffers: React.FC<IHotemPageRoomsWithoutOffersProps> =
    props => {
        const {className, contentClassName, rooms, renderRoom} = props;
        const deviceType = useDeviceType();

        const {isMobile} = deviceType;

        const {
            value: isRoomsWithoutOffersExpanded,
            toggle: roomsWithoutOffersToggle,
        } = useBoolean(false);

        const Wrapper = deviceType.isMobile ? Card : 'div';

        return (
            <Wrapper
                className={cx(
                    'roomsWithoutOffers',
                    deviceModMobile('roomsWithoutOffers', deviceType),
                    className,
                )}
                {...prepareQaAttributes(props)}
            >
                <div className={cx('header')}>
                    {deviceType.isDesktop && (
                        <div className={cx('icon')}>
                            <NoHotelPhotoM width="51" height="56" />
                        </div>
                    )}

                    <Heading
                        level={isMobile ? 2 : 3}
                        className={cx('label')}
                        onClick={roomsWithoutOffersToggle}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'trigger',
                        })}
                    >
                        {i18nBlock.roomsWithoutOfferTitle()}
                    </Heading>

                    <RotatingArrowIcon
                        rotated={isRoomsWithoutOffersExpanded}
                        onClick={roomsWithoutOffersToggle}
                        className={cx('toggle')}
                        {...(isMobile ? ICON_PROPS_MOBILE : null)}
                    />
                </div>

                <AutoHeightAnimateControl
                    canShowComponent={isRoomsWithoutOffersExpanded}
                >
                    <div
                        className={contentClassName}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'content',
                        })}
                    >
                        {rooms.map(renderRoom)}
                    </div>
                </AutoHeightAnimateControl>
            </Wrapper>
        );
    };

export default RoomsWithoutOffers;
