import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/hotels-HotelPageOffersInfo';

import WarningFilledIcon from 'icons/16/WarningFilled';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './SpecifyDatesWarning.scss';

const SpecifyDatesWarning: FunctionComponent<IWithClassName> = ({
    className,
}) => {
    return (
        <TextWithIcon
            className={className}
            iconLeft={WarningFilledIcon}
            text={i18nBlock.specifyCheckinAndCheckoutDates()}
            iconLeftClassName={cx('warningIcon')}
        />
    );
};

export default SpecifyDatesWarning;
