import {IHotelOffer, IHotelPartnerOffer} from 'types/hotels/offer/IHotelOffer';

export default function checkOffersDiscount(
    mainOffers: IHotelOffer[] | null | undefined,
    partnerOffers: IHotelPartnerOffer[] | null | undefined,
): boolean {
    const mainDiscount = mainOffers?.some(
        offer => offer.discountInfo?.strikethroughPrice,
    );
    const partnerDiscount = partnerOffers?.some(
        offer => offer.defaultOffer.discountInfo?.strikethroughPrice,
    );

    return Boolean(mainDiscount || partnerDiscount);
}
