import _flow from 'lodash/flow';
import {connect} from 'react-redux';

import {StoreInterface} from 'reducers/storeTypes';
import {
    startOrderPaymentActions,
    TStartOrderPaymentActions,
} from 'reducers/hotels/bookAndPayPage/orderInfo/actions';

import DeviceTypeProvider, {
    IDeviceTypeProvider,
} from 'components/DeviceTypeProvider/DeviceTypeProvider';

import bookInfoProvider, {
    IBookInfoComponentProps,
} from 'projects/hotels/containers/BookInfoProvider/BookInfoProvider';

import HotelsStartDeferredPaymentPage from './HotelsStartDeferredPaymentPage';

const mapStateToProps = undefined;

const mapDispatchToProps = {
    startPayment: startOrderPaymentActions.request,
};

interface IHotelsStartDeferredPaymentPageDispatchContainer {
    startPayment: TStartOrderPaymentActions;
}

export type THotelsStartDeferredPaymentPageContainerProps =
    IHotelsStartDeferredPaymentPageDispatchContainer &
        IBookInfoComponentProps &
        IDeviceTypeProvider;

export default _flow(
    bookInfoProvider({
        canFetchOfferInfo: false,
        canStartOrderPolling: true,
    }),
    connect<
        undefined,
        IHotelsStartDeferredPaymentPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    DeviceTypeProvider,
)(HotelsStartDeferredPaymentPage);
