import _flow from 'lodash/flow';
import {connect} from 'react-redux';

import {
    removeOrderActions,
    startOrderPaymentActions,
} from 'reducers/hotels/bookAndPayPage/orderInfo/actions';
import {IPlatformState} from 'reducers/avia/platform/reducer';

import bookInfoProvider, {
    IBookInfoComponentProps,
} from 'projects/hotels/containers/BookInfoProvider/BookInfoProvider';

import PaymentPage from './PaymentPage';

const mapDispatchToProps = {
    removeOrder: removeOrderActions.request,
    startPayment: startOrderPaymentActions.request,
};

interface IStateProps {
    platform: IPlatformState;
}

interface IPaymentPageContainerProps
    extends IBookInfoComponentProps,
        IStateProps {}

export type TPaymentPageProps = IPaymentPageContainerProps &
    typeof mapDispatchToProps;

export default _flow(
    bookInfoProvider(),
    connect(null, mapDispatchToProps),
)(PaymentPage);
