import {connect} from 'react-redux';
import _flow from 'lodash/flow';
import {withRouter, RouteComponentProps} from 'react-router-dom';

/* Types */
import {StoreInterface} from 'reducers/storeTypes';
/* SearchHotels Redux Actions */
import {
    searchHotelsActions,
    StartSearchHotelsType,
    clearSearchResult as clearSearchResultAction,
    ClearSearchResultType,
    stopSearchHotels as stopSearchHotelsAction,
    StopSearchType,
    changeHotelsIsFavoriteOnSearchActions,
    ChangeHotelsIsFavoriteOnSearchType,
    changeIsOpenForNoMoreFavoritesModalAction,
} from 'reducers/hotels/searchPage/search/actions';
/* Selection Redux Actions */
import {
    setActiveHotel as setActiveHotelAction,
    resetActiveHotel as resetActiveHotelAction,
} from 'reducers/hotels/searchPage/selection/actions';
/* HotelList Redux Actions */
import {setNavigationToken as setNavigationTokenAction} from 'reducers/hotels/searchPage/hotelList/actions';
/* Map Redux Actions */
import {
    clickMapMarker as clickMapMarkerAction,
    selectMapMarker as selectMapMarkerAction,
    setMapBounds as setMapBoundsAction,
} from 'reducers/hotels/searchPage/map/actions';
/* Filters Redux Actions */
import {
    changeFilterGroup as changeFilterGroupAction,
    ChangeFilterGroupType,
    resetFilters as resetFiltersAction,
    ResetFiltersActionType,
    changePriceFilter as changePriceFilterAction,
    ChangePriceFilterType,
    applyFilters as applyFiltersAction,
    ApplyFiltersActionType,
    updateCountFiltersActions,
    UpdateCountFiltersActionType,
    revertFilters as revertFiltersAction,
    RevertFiltersActionType,
    changeCurrentGeoIdFilter,
    resetFilterAction,
    ResetFilterActionType,
} from 'reducers/hotels/searchPage/filters/actions';
/* Sort Redux Actions */
import {
    setActiveSort as setActiveSortAction,
    TSetActiveSort,
} from 'reducers/hotels/searchPage/sort/actions';
import {resetFiltersAndSearch} from 'reducers/hotels/searchPage/filters/thunk';
import {
    openHotelsGeolocationErrorModalAction,
    TOpenHotelsGeolocationErrorModalAction,
} from 'reducers/common/hotelsGeolocationErrorModal/actions';
import {
    removeFavoriteHotel,
    addFavoriteHotel,
} from 'reducers/hotels/searchPage/search/thunkActions';
import {setSnackbarInfo} from 'reducers/common/snackbar/actions';
import {TSetSnackbarInfo} from 'reducers/common/snackbar/reducer';

/* Selectors */
import hotelsSearchPageSelector from 'selectors/hotels/search/hotelsSearchPageSelector';

/* Components */
import {
    IWithWindowSize,
    withWindowSize,
} from 'containers/withWindowSize/withWindowSize';

/* Redux Maps */
const mapStateToProps = hotelsSearchPageSelector;

const mapDispatchToProps: ISearchPageDispatchContainer = {
    /* Search */
    startSearch: searchHotelsActions.request,
    stopSearch: stopSearchHotelsAction,
    clearSearchResult: clearSearchResultAction,
    /* Selection */
    setActiveHotel: setActiveHotelAction,
    resetActiveHotel: resetActiveHotelAction,
    /* HotelList */
    setNavigationToken: setNavigationTokenAction,
    /* Map */
    clickMapMarker: clickMapMarkerAction,
    selectMapMarker: selectMapMarkerAction,
    setMapBounds: setMapBoundsAction,
    /* Filters */
    changeFilterGroup: changeFilterGroupAction,
    changePriceFilter: changePriceFilterAction,
    changeCurrentGeoIdFilter: changeCurrentGeoIdFilter,
    resetFilters: resetFiltersAction,
    resetFiltersAndSearch: resetFiltersAndSearch,
    resetFilter: resetFilterAction,
    applyFilters: applyFiltersAction,
    updateCountFilters: updateCountFiltersActions.request,
    revertFilters: revertFiltersAction,
    /* Sort */
    setActiveSort: setActiveSortAction,
    openHotelsGeolocationErrorModal: openHotelsGeolocationErrorModalAction,
    /* Favorites */
    changeHotelsIsFavoriteActions:
        changeHotelsIsFavoriteOnSearchActions.request,
    removeFavoriteHotel: removeFavoriteHotel,
    addFavoriteHotel: addFavoriteHotel,
    setSnackbarInfo: setSnackbarInfo,
    changeIsOpenForNoMoreFavoritesModal:
        changeIsOpenForNoMoreFavoritesModalAction,
};

/* Constants */
const WINDOW_SIZE_PROVIDER_THROTTLE = 100;

/* Components */
import SearchPage from './SearchPage';

type TSearchPagePropsContainer = ReturnType<typeof hotelsSearchPageSelector>;

interface ISearchPageDispatchContainer {
    /* Search */
    startSearch: StartSearchHotelsType;
    stopSearch: StopSearchType;
    clearSearchResult: ClearSearchResultType;
    /* Selection */
    setActiveHotel: typeof setActiveHotelAction;
    resetActiveHotel: typeof resetActiveHotelAction;
    /* HotelList*/
    setNavigationToken: typeof setNavigationTokenAction;
    /* Map */
    clickMapMarker: typeof clickMapMarkerAction;
    selectMapMarker: typeof selectMapMarkerAction;
    setMapBounds: typeof setMapBoundsAction;
    /* Filters */
    changeFilterGroup: ChangeFilterGroupType;
    resetFiltersAndSearch: typeof resetFiltersAndSearch;
    changePriceFilter: ChangePriceFilterType;
    changeCurrentGeoIdFilter: typeof changeCurrentGeoIdFilter;
    resetFilters: ResetFiltersActionType;
    applyFilters: ApplyFiltersActionType;
    updateCountFilters: UpdateCountFiltersActionType;
    revertFilters: RevertFiltersActionType;
    resetFilter: ResetFilterActionType;
    /* Sort */
    setActiveSort: TSetActiveSort;
    /*Error Modal*/
    openHotelsGeolocationErrorModal: TOpenHotelsGeolocationErrorModalAction;
    /* Favorites */
    changeHotelsIsFavoriteActions: ChangeHotelsIsFavoriteOnSearchType;
    removeFavoriteHotel: typeof removeFavoriteHotel;
    addFavoriteHotel: typeof addFavoriteHotel;
    setSnackbarInfo: TSetSnackbarInfo;
    changeIsOpenForNoMoreFavoritesModal: typeof changeIsOpenForNoMoreFavoritesModalAction;
}

export type TSearchPageContainer = TSearchPagePropsContainer &
    ISearchPageDispatchContainer &
    RouteComponentProps &
    IWithWindowSize;

export default _flow(
    withRouter,
    connect<
        TSearchPagePropsContainer,
        ISearchPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
    withWindowSize(WINDOW_SIZE_PROVIDER_THROTTLE),
)(SearchPage);
