import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {EResetFilterReason} from 'server/api/HotelsSearchAPI/types/IResetFilterInfo';

import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import NoHotels2S from 'icons/illustrations/NoHotels2/NoHotels2S';
import NoHotelsMapS from 'icons/illustrations/NoHotelsMap/NoHotelsMapS';

import cx from './NoHotelsInfo.scss';

interface INoHotelsInfoProps extends IWithClassName, IWithDeviceType {
    reason: EResetFilterReason;
}

const NoHotelsInfo: React.FC<INoHotelsInfoProps> = ({
    className,
    deviceType,
    reason,
}) => {
    const IconComponent =
        reason === EResetFilterReason.FILTERS ? NoHotels2S : NoHotelsMapS;

    return (
        <Flex
            className={cx(className, deviceType.isMobile && 'root_mobile')}
            flexDirection={deviceType.isMobile ? 'column' : 'row'}
        >
            <IconComponent
                className={cx('icon', deviceMods('icon', deviceType))}
            />
            <Flex flexDirection="column" justifyContent="center">
                <Heading level={2}>{i18nBlock.noHotelsFoundTitle()}</Heading>
                <Text className={cx('text')}>
                    {i18nBlock.noHotelsFoundText()}
                </Text>
            </Flex>
        </Flex>
    );
};

export default NoHotelsInfo;
