import {useDispatch} from 'react-redux';
import {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {IResetFilterAction} from 'server/api/HotelsSearchAPI/types/IResetFilterInfo';

import {resetFilterAction} from 'reducers/hotels/searchPage/filters/actions';

import Flex from 'components/Flex/Flex';
import ResetItem from 'projects/hotels/pages/SearchPage/components/BaseSearchPage/components/FilterResets/components/ResetList/components/ResetItem';

import cx from './ResetList.scss';

interface IResetListProps extends IWithClassName, IWithDeviceType {
    actions: IResetFilterAction[];
}

const ResetList: React.FC<IResetListProps> = ({
    className,
    actions,
    deviceType,
}) => {
    const dispatch = useDispatch();
    const resetFilter = useCallback(
        (resetAction: IResetFilterAction) =>
            dispatch(resetFilterAction(resetAction)),
        [dispatch],
    );

    return (
        <Flex
            flexWrap="wrap"
            className={cx(className, deviceType.isMobile && 'root_mobile')}
        >
            {actions.map((action, index) => (
                <ResetItem
                    key={index + action.name}
                    action={action}
                    onReset={resetFilter}
                />
            ))}
        </Flex>
    );
};

export default ResetList;
