import {useCallback, memo} from 'react';

import {
    EResetFilterActionEffect,
    IResetFilterAction,
} from 'server/api/HotelsSearchAPI/types/IResetFilterInfo';

import Intent, {EIntentTheme} from 'components/Intent/Intent';

import cx from './ResetItem.scss';

export interface IResetFilterItemProps {
    action: IResetFilterAction;
    onReset: (resetAction: IResetFilterAction) => void;
}

function getThemeByEffect(effect: EResetFilterActionEffect): EIntentTheme {
    if (effect === EResetFilterActionEffect.ALL) {
        return EIntentTheme.ALERT;
    }

    return EIntentTheme.PRIMARY;
}

const ResetItem: React.FC<IResetFilterItemProps> = ({action, onReset}) => {
    const handleClick = useCallback(() => {
        onReset(action);
    }, [action, onReset]);

    return (
        <Intent
            className={cx('resetAction')}
            theme={getThemeByEffect(action.effect)}
            size="l"
            onCancel={handleClick}
            onClick={handleClick}
            text={action.name}
        />
    );
};

export default memo(ResetItem);
