import React, {useRef} from 'react';

import {useHeaderScrollSlide} from 'hooks/useHeaderScrollSlide';

import ScopeContext from 'contexts/ScopeContext';

import cx from './SearchFormScroller.scss';

export interface ISearchFormScrollerProps {}

const HIDE_THRESHOLD = 70;
const RISE_THRESHOLD = 35;

const SearchFormScroller: React.FC<ISearchFormScrollerProps> = ({children}) => {
    const containerRef = useRef<HTMLDivElement>(null);

    const {isRaised, isVisible} = useHeaderScrollSlide({
        hideThreshold: HIDE_THRESHOLD,
        riseThreshold: RISE_THRESHOLD,
    });

    // жесткая привязка на лего класс попапа
    // иначе нужно прокидывать когда открыт один из попапов на форме что потребует большой рефакторинг поисковой формы
    const isFiltersPoputOpen = Boolean(
        containerRef.current?.querySelector('.Popup2'),
    );

    return (
        <div
            ref={containerRef}
            className={cx('searchFormScroller', {
                searchFormScroller__hidden: !isFiltersPoputOpen && !isVisible,
                searchFormScroller__raised: isRaised,
            })}
        >
            <ScopeContext.Provider value={containerRef.current || undefined}>
                {children}
            </ScopeContext.Provider>
        </div>
    );
};

export default SearchFormScroller;
